% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmneighbourhood.R
\name{kmnneighbourhood}
\alias{kmnneighbourhood}
\title{Compute the n-neighbourhod of a state within a knowledge structure}
\usage{
kmnneighbourhood(state, struct, distance, include = FALSE)
}
\arguments{
\item{state}{Binary vector representing a knowledge state}

\item{struct}{Binary matrix representing a knowledge structure}

\item{distance}{Size of the n-neighbourhood}

\item{include}{Boolean whether the original state should be included
(defaul FALSE)}
}
\value{
Matrix containing the neighbouring states, one per row
}
\description{
\code{kmnneighbourhood} computes the n-neighbourhood of a state
within a knowledge structure, i.e. the family of all other
states with a symmetric set difference maximal n.
}
\examples{
kmnneighbourhood(c(1,1,0,0), xpl$space, 2)

}
\seealso{
Other Fringes & paths: 
\code{\link{kmfringe}()},
\code{\link{kmgradations}()},
\code{\link{kmlearningpaths}()},
\code{\link{kmneighbourhood}()}
}
\concept{Fringes & paths}
