% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1_clonality_airr.R
\name{airr_clonality}
\alias{airr_clonality}
\alias{airr_clonality_line}
\alias{airr_clonality_rank}
\alias{airr_clonality_prop}
\title{Clonality - receptor overabundance statistics for immune repertoires}
\usage{
airr_clonality_line(
  idata,
  limit = 1e+05,
  autojoin = getOption("immundata.autojoin", TRUE),
  format = c("long", "wide")
)

airr_clonality_rank(
  idata,
  bins = c(10, 30, 100, 300, 1000, 10000, 1e+05),
  autojoin = getOption("immundata.autojoin", TRUE),
  format = c("long", "wide")
)

airr_clonality_prop(
  idata,
  bins = c(Hyperexpanded = 0.01, Large = 0.001, Medium = 1e-04, Small = 1e-05, Rare =
    1e-06),
  autojoin = getOption("immundata.autojoin", TRUE),
  format = c("long", "wide")
)
}
\arguments{
\item{idata}{An \code{ImmunData} object.}

\item{limit}{Positive integer >= 10: maximum number of top receptors to keep
\strong{per repertoire} (default \code{100000}).}

\item{autojoin}{Logical. If TRUE, join repertoire metadata by the schema repertoire id.
Change the default behaviour by calling \code{options(immunarch.autojoin = FALSE)}.}

\item{format}{String. One of \code{"long"} ("long" tibble with \code{imd_repertoire_id}, facet
columns, and \code{value}; useful for visualizations) or \code{"wide"} (wide/unmelted table of features,
with each row corresponding to a specific repertoire / pair of repertoires; useful for Machine Learning).}

\item{bins}{A \strong{named} numeric vector of thresholds (e.g.,
\code{c(Hyperexpanded = 1e-2, Large = 1e-3, ...)}). Names become bin labels and
must be non-empty. Internally sorted in descending order.}
}
\value{
\subsection{\code{airr_clonality_line}}{

A tibble with columns:
\itemize{
\item \code{repertoire_id} - repertoire identifier
\item \code{index} - rank within repertoire (1 = most abundant)
\item \code{count} - receptor count used for ranking
\item plus any repertoire metadata columns carried from \code{idata$repertoires}
}
}

\subsection{\code{airr_clonality_rank}}{

A tibble with
\itemize{
\item \code{repertoire_id}
\item \code{clonal_rank_bin} - the rank threshold (e.g., \code{10}, \code{100}, ...)
\item \code{occupied_prop} - sum of \code{proportion} within the bin
\item plus repertoire metadata columns from \code{idata$repertoires}
}
}

\subsection{\code{airr_clonality_prop}}{

A tibble with
\itemize{
\item \code{repertoire_id}
\item \code{clonal_prop_bin} - factor-like label from \code{names(bins)} or \code{"Ultra-rare"}
\item \code{occupied_prop} - sum of \code{proportion} within the bin
\item plus repertoire metadata columns from \code{idata$repertoires}
}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A family of functions to quantify \strong{receptor overabundance} per repertoire. Helps in deciphering the structure and partition the repertoire.
\subsection{Available functions}{

Supported methods are the following.
}

\code{airr_clonality_line} - build ranked abundance lines: for each
repertoire, take the top \code{limit} receptors by \code{count} and attach repertoire
metadata. Useful for per-repertoire rank-abundance plots.

\code{airr_clonality_rank} - aggregate clonal space by \strong{rank bins}.
Receptors are ordered by \code{proportion} within each repertoire; each receptor
is assigned to the smallest threshold in \code{bins} that contains its rank.

\code{airr_clonality_prop} - aggregate clonal space by \strong{proportion bins}.
Each receptor is assigned to a named bin according to its \code{proportion}
(e.g., \code{Hyperexpanded >= 1e-2}, \code{Large >= 1e-3}, ...). Thresholds are matched in
descending order; unmatched receptors fall into \code{"Ultra-rare"}.
}
\examples{
# Limit the number of threads used by the underlying DB for this session.
# Change this only if you know what you're doing (e.g., multi-user machines, shared CI/servers).
db_exec("SET threads TO 1")

# Load data
\dontrun{
immdata <- get_test_idata() |> agg_repertoires("Therapy")
}

#
# airr_clonality_line
#
\dontrun{
top_line <- airr_clonality_line(immdata, limit = 1000)
}

#
# airr_clonality_rank
#
\dontrun{
rank_stat <- airr_clonality_rank(immdata, bins = c(10, 100))
}

#
# airr_clonality_prop
#
\dontrun{
prop_stat <- airr_clonality_prop(immdata)
}

}
\seealso{
\itemize{
\item Per-repertoire summaries: \link{annotate_clonality}
\item Data container: \link[immundata:ImmunData]{immundata::ImmunData}
}
}
\concept{Clonality}
