% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural-properties.R
\name{edge_density}
\alias{edge_density}
\title{Graph density}
\usage{
edge_density(graph, loops = FALSE)
}
\arguments{
\item{graph}{The input graph.}

\item{loops}{Logical constant, whether loop edges may exist in the graph.
This affects the calculation of the largest possible number of edges in the
graph. If this parameter is set to FALSE yet the graph contains self-loops,
the result will not be meaningful.}
}
\value{
A real constant. This function returns \code{NaN} (=0.0/0.0) for an
empty graph with zero vertices.
}
\description{
The density of a graph is the ratio of the actual number of edges and the
largest possible number of edges in the graph, assuming that no multi-edges
are present.
}
\details{
The concept of density is ill-defined for multigraphs. Note that this function
does not check whether the graph has multi-edges and will return meaningless
results for such graphs.
}
\examples{

edge_density(make_empty_graph(n = 10)) # empty graphs have density 0
edge_density(make_full_graph(n = 10)) # complete graphs have density 1
edge_density(sample_gnp(n = 100, p = 0.4)) # density will be close to p

# loop edges
g <- make_graph(c(1, 2, 2, 2, 2, 3)) # graph with a self-loop
edge_density(g, loops = FALSE) # this is wrong!!!
edge_density(g, loops = TRUE) # this is right!!!
edge_density(simplify(g), loops = FALSE) # this is also right, but different

}
\references{
Wasserman, S., and Faust, K.  (1994).  Social Network Analysis:
Methods and Applications.  Cambridge: Cambridge University Press.
}
\seealso{
\code{\link[=vcount]{vcount()}}, \code{\link[=ecount]{ecount()}}, \code{\link[=simplify]{simplify()}}
to get rid of the multiple and/or loop edges.

Other structural.properties: 
\code{\link{bfs}()},
\code{\link{component_distribution}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{coreness}()},
\code{\link{degree}()},
\code{\link{dfs}()},
\code{\link{distance_table}()},
\code{\link{feedback_arc_set}()},
\code{\link{feedback_vertex_set}()},
\code{\link{girth}()},
\code{\link{is_acyclic}()},
\code{\link{is_dag}()},
\code{\link{is_matching}()},
\code{\link{k_shortest_paths}()},
\code{\link{knn}()},
\code{\link{reciprocity}()},
\code{\link{subcomponent}()},
\code{\link{subgraph}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{unfold_tree}()},
\code{\link{which_multiple}()},
\code{\link{which_mutual}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{structural.properties}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Structural.html#igraph_density}{\code{density()}}.}

