% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{theme}
\alias{theme}
\title{Modify components of a theme}
\arguments{
\item{tern.axis.arrow}{Base Arrow Line (`element_line`; inherits from `axis.line`)}

\item{tern.axis.arrow.T}{Arrow Line for TOP Axis (`element_line`; inherits from `tern.axis.arrow`)}

\item{tern.axis.arrow.L}{Arrow Line for LHS Axis (`element_line`; inherits from `tern.axis.arrow`)}

\item{tern.axis.arrow.R}{Arrow Line for RHS Axis (`element_line`; inherits from `tern.axis.arrow`)}

\item{tern.axis.arrow.text}{Base Arrow Label (`element_text`; inherits from `tern.axis.text`)}

\item{tern.axis.arrow.text.T}{Arrow Label on TOP Axis (`element_text`; inherits from `tern.axis.arrow.text`)}

\item{tern.axis.arrow.text.L}{Arrow Label on LHS Axis (`element_text`; inherits from `tern.axis.arrow.text`)}

\item{tern.axis.arrow.text.R}{Arrow Label on RHS Axis (`element_text`; inherits from `tern.axis.arrow.text`)}

\item{tern.axis.arrow.start}{Proportion of Axis when Arrow Starts (`numeric`)}

\item{tern.axis.arrow.finish}{Proportion of Axis when Arrow Finishes (`numeric`)}

\item{tern.axis.arrow.sep}{Arrows Seperation from Axis (`numeric`)}

\item{tern.axis.arrow.show}{Arrows Show or Hide (`logical`)}

\item{tern.axis.clockwise}{Clockwise or Anticlockwise Precession (`logical`)}

\item{tern.axis.vshift}{Amount to nudge the plot vertically (`numeric`)}

\item{tern.axis.hshift}{Amount to nudge the plot horizontally (`numeric`)}

\item{tern.axis.line.ontop}{Bring Axis Borders on Top of Everything (Depreciated) (`logical`)}

\item{tern.axis.line}{Base Line (`element_line`; inherits from `axis.line`)}

\item{tern.axis.line.T}{Line for TOP Axis (`element_line`; inherits from `tern.axis.line`)}

\item{tern.axis.line.L}{Line for LHS Axis (`element_line`; inherits from `tern.axis.line`)}

\item{tern.axis.line.R}{Line for RHS Axis (`element_line`; inherits from `tern.axis.line`)}

\item{tern.axis.text}{Base Text (`element_text`; inherits from `axis.text`)}

\item{tern.axis.text.T}{Text for TOP Axis (`element_text`; inherits from `tern.axis.text`)}

\item{tern.axis.text.L}{Text for LHS Axis (`element_text`; inherits from `tern.axis.text`)}

\item{tern.axis.text.R}{Text for RHS Axis (`element_text`; inherits from `tern.axis.text`)}

\item{tern.axis.text.show}{Axis Labels Show or Hide (`logical`)}

\item{tern.axis.ticks}{Base Ticks (`element_line`; inherits from `axis.ticks`)}

\item{tern.axis.ticks.length.major}{Ticks Major Ticklength (`unit`)}

\item{tern.axis.ticks.length.minor}{Ticks Minor Ticklength (`unit`)}

\item{tern.axis.ticks.major}{Base Major Ticks (`element_line`; inherits from `tern.axis.ticks`)}

\item{tern.axis.ticks.major.T}{Base Major Ticks for TOP Axis (`element_line`; inherits from `tern.axis.ticks.major`)}

\item{tern.axis.ticks.major.L}{Base Major Ticks for LHS Axis (`element_line`; inherits from `tern.axis.ticks.major`)}

\item{tern.axis.ticks.major.R}{Base Major Ticks for RHS Axis (`element_line`; inherits from `tern.axis.ticks.major`)}

\item{tern.axis.ticks.minor}{Base Minor Ticks (`element_line`; inherits from `tern.axis.ticks`)}

\item{tern.axis.ticks.minor.T}{Base Minor Ticks for TOP Axis (`element_line`; inherits from `tern.axis.ticks.minor`)}

\item{tern.axis.ticks.minor.L}{Base Minor Ticks for LHS Axis (`element_line`; inherits from `tern.axis.ticks.minor`)}

\item{tern.axis.ticks.minor.R}{Base Minor Ticks for RHS Axis (`element_line`; inherits from `tern.axis.ticks.minor`)}

\item{tern.axis.ticks.outside}{Ticks Outside or Inside (`logical`)}

\item{tern.axis.ticks.primary.show}{Ticks Show Primary (`logical`)}

\item{tern.axis.ticks.secondary.show}{Ticks Show Secondary (`logical`)}

\item{tern.axis.title}{Base Apex Title (`element_text`; inherits from `axis.title`)}

\item{tern.axis.title.T}{Apex Title for TOP Axis (`element_text`; inherits from `tern.axis.title`)}

\item{tern.axis.title.L}{Apex Title for LHS Axis (`element_text`; inherits from `tern.axis.title`)}

\item{tern.axis.title.R}{Apex Title for RHS Axis (`element_text`; inherits from `tern.axis.title`)}

\item{tern.axis.title.show}{Apex Titles Show or Hide (`logical`)}

\item{tern.panel.expand}{The amount to expand the ternary plotting panel, in ratio to npc units (`numeric`)}

\item{tern.panel.grid.major}{Base Major Gridline (`element_line`; inherits from `panel.grid.major`)}

\item{tern.panel.grid.major.T}{Major Gridline for TOP Axis (`element_line`; inherits from `tern.panel.grid.major`)}

\item{tern.panel.grid.major.L}{Major Gridline for LHS Axis (`element_line`; inherits from `tern.panel.grid.major`)}

\item{tern.panel.grid.major.R}{Major Gridline for RHS Axis (`element_line`; inherits from `tern.panel.grid.major`)}

\item{tern.panel.grid.major.show}{Show or Hide Major Gridline (`logical`)}

\item{tern.panel.grid.minor}{Base Minor Gridline (`element_line`; inherits from `panel.grid.minor`)}

\item{tern.panel.grid.minor.T}{Minor Gridline for TOP Axis (`element_line`; inherits from `tern.panel.grid.minor`)}

\item{tern.panel.grid.minor.L}{Minor Gridline for LHS Axis (`element_line`; inherits from `tern.panel.grid.minor`)}

\item{tern.panel.grid.minor.R}{Minor Gridline for RHS Axis (`element_line`; inherits from `tern.panel.grid.minor`)}

\item{tern.panel.grid.minor.show}{Show or Hide Minor Gridline (`logical`)}

\item{tern.panel.grid.ontop}{Bring grids, axis and axis labels on top of everything else (`logical`)}

\item{tern.panel.mask.show}{Show or Hide the Clipping Mask (`logical`)}

\item{tern.panel.rotate}{The amount to rotate the ternary diagram in degrees (`numeric`)}

\item{tern.plot.background}{Background of Ternary Clipping Area** (`element_rect`; inherits from `plot.background`)}

\item{tern.plot.latex}{Whether to parse characters as latex commands (`logical`)}
}
\description{
Custom theme elements for ggtern
}
\details{
Modify components of a theme (ggtern version)

Use `theme()` to modify individual components of a theme, allowing
you to control the appearance of all non-data components of the plot.
`theme()` only affects a single plot: see [theme_update()] if
you want modify the active theme, to affect all subsequent plots.
}
\section{Theme inheritance}{

Theme elements inherit properties from other theme elements.
For example, `axis.title.x` inherits from `axis.title`,
which in turn inherits from `text`. All text elements inherit
directly or indirectly from `text`; all lines inherit from
`line`, and all rectangular objects inherit from `rect`.
This means that you can modify the appearance of multiple elements by
setting a single high-level component.
}

\seealso{
\code{\link[ggplot2]{theme}}
}
\author{
Nicholas Hamilton
}
