% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot-facet-sector.R
\name{facet_sector}
\alias{facet_sector}
\title{Polar coordinates with Facet support}
\usage{
facet_sector(
  facets,
  sector_spacing = pi/180,
  drop = TRUE,
  radial = deprecated(),
  spacing_theta = deprecated()
)
}
\arguments{
\item{facets}{A set of variables or expressions quoted by \code{\link[ggplot2:vars]{vars()}}
and defining faceting groups on the rows or columns dimension.
The variables can be named (the names are passed to \code{labeller}).

For compatibility with the classic interface, can also be a
formula or character vector. Use either a one sided formula, \code{~a + b},
or a character vector, \code{c("a", "b")}.}

\item{sector_spacing}{The size of spacing between different panel. A numeric
of the radians or a \code{\link[ggplot2:element]{rel()}} object.}

\item{drop}{If \code{TRUE}, the default, all factor levels not used in the
data will automatically be dropped. If \code{FALSE}, all factor levels
will be shown, regardless of whether or not they appear in the data.}

\item{radial}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please add the coordinate
system directly to the ggplot instead.}

\item{spacing_theta}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{sector_spacing} instead.}
}
\description{
Draw each panel in a sector of the polar coordinate system. If
\code{facet_sector()} is used in a ggplot, the coordinate system must be created
with \code{\link[=coord_circle]{coord_circle()}} or \code{\link[ggplot2:coord_radial]{coord_radial()}}.
}
\examples{
ggplot(mtcars, aes(disp, mpg)) +
    geom_point() +
    facet_sector(vars(cyl)) +
    coord_circle(
        start = -0.4 * pi, end = 0.4 * pi, inner.radius = 0.3,
        outer.radius = 0.8, expand = TRUE
    )
}
