% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-vegetation-indices.R
\name{calculate_multiple_indices}
\alias{calculate_multiple_indices}
\title{Calculate multiple vegetation indices at once}
\usage{
calculate_multiple_indices(
  spectral_data = NULL,
  indices = c("NDVI", "EVI", "SAVI"),
  output_stack = TRUE,
  region_boundary = NULL,
  parallel = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{spectral_data}{Multi-band raster, directory path, or individual bands}

\item{indices}{Vector of index names to calculate}

\item{output_stack}{Return as single multi-layer raster (TRUE) or list (FALSE)}

\item{region_boundary}{Optional region boundary for clipping}

\item{parallel}{Use parallel processing for multiple indices}

\item{verbose}{Print progress messages}

\item{...}{Additional arguments passed to calculate_vegetation_index}
}
\value{
SpatRaster stack or list of indices
}
\description{
Calculate multiple vegetation indices from the same spectral data in a single operation.
Efficient for comparative analysis and comprehensive vegetation assessment.
Supports directory input and automatic CRS handling.
}
\examples{
\dontrun{
# These examples require satellite imagery files (Landsat/Sentinel data etc.)
# Calculate multiple basic indices from directory
multi_indices <- calculate_multiple_indices(
  spectral_data = "/path/to/sentinel/bands/",
  indices = c("NDVI", "EVI", "SAVI", "MSAVI"),
  auto_detect_bands = TRUE
)

# Comprehensive vegetation analysis from individual files
veg_analysis <- calculate_multiple_indices(
  red = red_band, nir = nir_band, blue = blue_band,
  indices = c("NDVI", "EVI", "ARVI", "GNDVI", "DVI"),
  output_stack = TRUE,
  region_boundary = "Iowa"
)

# Directory with custom band matching
stress_indices <- calculate_multiple_indices(
  spectral_data = "/path/to/bands/",
  indices = c("PRI", "SIPI", "NDRE"),
  band_names = c("red", "green", "nir", "red_edge"),
  output_stack = TRUE
)
}

}
