% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motifs_search_plot.R
\name{motifs_search_plot}
\alias{motifs_search_plot}
\title{Plot Motif Search Results}
\usage{
motifs_search_plot(
  motifs_search_results,
  ylab = "",
  freq_threshold = 5,
  top_n = "all",
  plot_curves = TRUE,
  transformed = FALSE
)
}
\arguments{
\item{motifs_search_results}{A list containing the output from the `motifs_search` function. This
includes elements such as `V0`, `V1`, `V_frequencies`, `Y0`, `Y1`, `V_length`, `V_occurrences`,
`V_mean_diss`, and `R_motifs`, which store information about the detected motifs and their properties.}

\item{ylab}{A character string specifying the label for the y-axis in the plots. This label will be
appended with the dimension number to create individual titles for each plot. Default is an empty
string (`''`).}

\item{freq_threshold}{An integer indicating the minimum frequency a motif must have to be included
in the plots. Only motifs with a frequency equal to or greater than `freq_threshold` will be
visualized. Default value is `5`.}

\item{top_n}{Determines how many motifs to plot based on their frequency. If set to `'all'`, all
motifs meeting the `freq_threshold` will be plotted. If an integer is provided, only the top
`top_n` motifs with the highest frequencies will be displayed. Default is `'all'`.}

\item{plot_curves}{A logical value indicating whether to plot all underlying curves with colored
motifs highlighted. If `TRUE`, the function overlays motifs on the curves for better visualization.
Default is `TRUE`.}

\item{transformed}{A logical value indicating whether to normalize the curve segments to the interval [0,1] before applying the dissimilarity measure. Setting `transformed = TRUE` scales each curve segment between 0 and 1, which allows for the identification of motifs with consistent shapes but different amplitudes. This normalization is useful for cases where motif occurrences may vary in amplitude but have similar shapes, enabling better pattern recognition across diverse data scales.}
}
\value{
The function does not return a value but generates plots visualizing the motifs and their occurrences
across different dimensions. It creates separate plots for each dimension and includes legends for
easy identification of motifs.
}
\description{
The `motifs_search_plot` function visualizes the results obtained from the `motifs_search` function.
It generates plots for detected motifs across multiple dimensions, displaying both the motifs and their
corresponding derivative curves (if available). Users can filter motifs based on frequency thresholds
and choose to display either all motifs or the top `n` motifs. Additionally, the function provides an
option to plot all underlying curves with colored motifs highlighted.
}
\details{
The `motifs_search_plot` function performs the following steps:
\enumerate{
  \item Validates input parameters, ensuring that the frequency threshold and `top_n` are appropriate.
  \item Selects motifs that meet the frequency threshold and, if specified, limits the number of motifs
    to the top `n`.
  \item For each dimension, it plots the motif centers (`V0`) and their derivatives (`V1`, if available).
  \item If `plot_curves` is `TRUE`, it overlays the motifs on the original curves, highlighting them with
    distinct colors.
  \item Adds legends to the plots for clear identification of each motif.
}
}
