% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrset.R
\name{mrset}
\alias{mrset}
\alias{mdset}
\alias{mrset_f}
\alias{mdset_f}
\alias{mrset_p}
\alias{mdset_p}
\alias{mrset_t}
\alias{mdset_t}
\title{Create multiple response set/multiple dichotomy set from variables}
\usage{
mrset(..., label = NULL)

mdset(..., label = NULL)

mrset_f(..., label = NULL)

mdset_f(..., label = NULL)

mrset_p(..., label = NULL)

mdset_p(..., label = NULL)

mrset_t(..., label = NULL)

mdset_t(..., label = NULL)
}
\arguments{
\item{...}{variables}

\item{label}{character optional label for multiple response set}
}
\value{
data.frame of class \code{category}/\code{dichotomy}
}
\description{
These functions are intended for usage with tables - \link{tables},
\link{cross_cpct}, \link{cross_fun}. Result of \code{mrset} is considered as 
muliple-response set with category encoding and result of \code{mdset} is 
considered as multiple response set with dichotomy (dummy) encoding e. g. 
with 0 or 1 in the each column. Each column in the \code{dichotomy} is 
indicator of absence or presence of particular feature. Both functions don't 
convert its arguments to anything - it is supposed that arguments already 
have appropriate encoding. For conversation see \link{as.dichotomy} or 
\link{as.category}. 
\itemize{
\item \code{mrset_f} and \code{mdset_f} select variables by fixed pattern. Fixed
pattern can be unquoted. For details see \link{..f}.
\item \code{mrset_p} and \code{mdset_p} select variables for
multiple-responses by perl-style regular expression. For details see \link{..p}.
\item \code{mrset_t} and \code{mdset_t} select variables by expanding text
arguments. For details see \link{..t} and \link[maditr]{text_expand}.
}
}
\examples{
data.table::setDTthreads(2)
data(product_test)

cross_cpct(product_test, mrset(a1_1 \%to\% a1_6))

# same result
cross_cpct(product_test, mrset_f(a1_))

# same result
cross_cpct(product_test, mrset_p("a1_"))

# same result
cross_cpct(product_test, mrset_t("a1_{1:6}"))
}
\seealso{
\link{as.dichotomy}, \link{as.category}
}
