% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{send_whatsapp_audio}
\alias{send_whatsapp_audio}
\title{Send WhatsApp audio (voice note)}
\usage{
send_whatsapp_audio(
  client,
  number,
  audio,
  delay = NULL,
  link_preview = NULL,
  mentions_everyone = NULL,
  mentioned = NULL,
  quoted = NULL,
  verbose = FALSE
)
}
\arguments{
\item{client}{An \code{\link[=evo_client]{evo_client()}} object.}

\item{number}{Character. Recipient in E.164 format (e.g., \code{"+5581999..."}).}

\item{audio}{URL or base64.}

\item{delay}{Integer (ms). Optional presence delay before sending.}

\item{link_preview}{Logical. Enable URL link preview.}

\item{mentions_everyone}{Logical. Mention everyone (if applicable).}

\item{mentioned}{Character vector of JIDs to mention (e.g., \code{jid("+55...")}).}

\item{quoted}{Optional list with Baileys message \code{key} and \code{message} (reply-to).}

\item{verbose}{Logical. If TRUE, logs request/response details.}
}
\value{
A named list parsed from the JSON response produced by the Evolution API for
audio messages.
The list may include message ID, queue metadata, and delivery-related fields.
The HTTP status code is stored in \code{attr(result, "http_status")}.
This output indicates that the audio message request was accepted by the API.
}
\description{
Send WhatsApp audio (voice note)
}
