% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_rdm.R
\name{model_rdm}
\alias{model_rdm}
\title{Range directional model.}
\usage{
model_rdm(datadea,
            dmu_eval = NULL,
            dmu_ref = NULL,
            orientation = c("no", "io", "oo"),
            irdm = FALSE,
            maxslack = TRUE,
            weight_slack_i = 1,
            weight_slack_o = 1,
            compute_target = TRUE,
            returnlp = FALSE,
            ...)
}
\arguments{
\item{datadea}{A \code{deadata} object, including \code{n} DMUs, \code{m} inputs and \code{s} outputs.}

\item{dmu_eval}{A numeric vector containing which DMUs have to be evaluated.
If \code{NULL} (default), all DMUs are considered.}

\item{dmu_ref}{A numeric vector containing which DMUs are the evaluation reference set.
If \code{NULL} (default), all DMUs are considered.}

\item{orientation}{A string, equal to "no" (non-oriented), "io" (input oriented),
or "oo" (output oriented).}

\item{irdm}{Logical. If it is \code{TRUE}, it applies the IRDM (inverse range
directional model).}

\item{maxslack}{Logical. If it is \code{TRUE}, it computes the max slack solution.}

\item{weight_slack_i}{A value, vector of length \code{m}, or matrix \code{m} x
\code{ne} (where \code{ne} is the length of \code{dmu_eval}) with the weights
of the input slacks for the max slack solution.}

\item{weight_slack_o}{A value, vector of length \code{s}, or matrix \code{s} x
\code{ne} (where \code{ne} is the length of \code{dmu_eval}) with the weights
of the output slacks for the max slack solution.}

\item{compute_target}{Logical. If it is \code{TRUE}, it computes targets of the
max slack solution. We note that we call "targets" to the "efficient projections"
in the strongly efficient frontier.}

\item{returnlp}{Logical. If it is \code{TRUE}, it returns the linear problems
(objective function and constraints) of stage 1.}

\item{...}{Ignored, for compatibility issues.}
}
\value{
A list of class \code{dea} with the results for the evaluated DMUs (\code{DMU} component),
 along with any other necessary information to replicate the results, such as
 the name of the model and parameters \code{orientation}, \code{rts},
 \code{dmu_eval} and \code{dmu_ref}.
}
\description{
Range directional model from Portela et al. (2004).
}
\note{
Undesirable inputs/outputs are treated as negative inputs/outputs in this model.
}
\references{
Portela, M.; Thanassoulis, E.; Simpson, G. (2004). "Negative data in DEA: a
directional distance approach applied to bank branches", Journal of the Operational
Research Society, 55 1111-1121.
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
