% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_title.R
\name{dataset_title}
\alias{dataset_title}
\alias{dataset_title<-}
\title{Get or Set the Title of a Dataset}
\usage{
dataset_title(x)

dataset_title(x, overwrite = FALSE) <- value
}
\arguments{
\item{x}{A dataset object created by \code{\link[=dataset_df]{dataset_df()}} or \code{\link[=as_dataset_df]{as_dataset_df()}}.}

\item{overwrite}{Logical. If \code{TRUE}, the existing title is replaced. If
\code{FALSE} (default) and a title is already present, a warning is issued and
the title is not changed.}

\item{value}{A character string representing the new title. If \code{NULL}, a
placeholder value \code{":tba"} is assigned. If \code{value} is a character vector of
length > 1, an error is raised.}
}
\value{
\code{dataset_title()} returns the current dataset title as a character
string. \verb{dataset_title<-()} returns the updated dataset object (invisible).
}
\description{
Retrieve or assign the main title of a dataset, typically used
as the primary label in metadata exports (e.g., DataCite or Dublin Core).
}
\details{
According to the \href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/elements11/title/}{Dublin Core specification for \code{title}},
the title represents the name by which the resource is formally known.

The DataCite metadata schema supports multiple titles (e.g., translated,
alternative), but this function currently supports only a single main title.
}
\examples{
dataset_title(orange_df)

# Set a new title with overwrite = TRUE
dataset_title(orange_df, overwrite = TRUE) <- "The Growth of Orange Trees"
dataset_title(orange_df)

}
\seealso{
Other bibliographic helper functions: 
\code{\link{contributor}()},
\code{\link{creator}()},
\code{\link{dataset_format}()},
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{get_bibentry}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{publisher}()},
\code{\link{relation}()},
\code{\link{rights}()},
\code{\link{subject}()}
}
\concept{bibliographic helper functions}
