#' Camera trap data on mammals in Ruaha National Park, southern Tanzania.
#' @description
#' Dataset contains 14604 observations and sampling was carried out for 
#' two months during the
#' dry season of 2013 and two months during the wet season of 2014. Each 
#' camera station is associated
#' with a randomly placed camera and a trail-based camer, with the aim of 
#' comparing communities 
#' resulting from the two camera trap placement strategies. 
#' @usage
#' data(cameratrap)
#' @format Contains 6 variables, as follows:
#' \describe{
#'   \item{reference}{Number of observation od datasets.}
#'   \item{placement}{Type of "placement" placed in each station (random or
#'    trail).}
#' \item{season}{Season where were made the samplings.}
#' \item{station}{Station where were collected the data.}
#' \item{specie}{Name of specie medium to large terrestrial mammals.}
#' \item{date.time}{The date and time of each photographic event is 
#' also given.}
#'  }
#' @source 
#' The data were provided by Dr Jeremy Cusack.  
#' @references
#'  - Cusack J, Dickman A, Rowcliffe M, Carbone C, Macdonald D, 
#'  Coulson T. 2016. Random versus
#'   game trail-based camera trap placement strategy for monitoring terrestrial
#'    mammal communities. PLoS ONE 10(5): e0126373.
#' @examples
#' data(cameratrap)    
#' head(cameratrap) 
'cameratrap'
