% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demographics.R
\docType{data}
\name{demographics}
\alias{demographics}
\title{Household demographic metadata.}
\format{
A data frame with 801 rows and 8 variables
\itemize{
\item household_id: Uniquely identifies each household
\item age: Estimated age range
\item income: Household income range
\item home_ownership: Homeowner status (Homeowner, Renter, Unknown)
\item marital_status: Marital status (Married, Single, Unknown)
\item household_size: Size of household up to 5+
\item household_comp: Household composition description
\item kids_count: Number of children present up to 3+
}
}
\source{
84.51°, Customer Journey study, \url{https://www.8451.com/area51/}
}
\usage{
demographics
}
\value{
\item{demographics}{a tibble}
}
\description{
Household demographic metadata for households participating in the Customer Journey study.
Due to nature of the data, the demographic information is not available for all
households.
}
\examples{
\donttest{
# full data set
demographics

# Transaction line items that don't have household metadata
require("dplyr")
transactions_sample \%>\%
  anti_join(demographics, "household_id")
}

}
\keyword{datasets}
