% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_encoding_loo.R,
%   R/target_encoding_mean.R, R/target_encoding_rank.R
\name{target_encoding_loo}
\alias{target_encoding_loo}
\alias{target_encoding_mean}
\alias{target_encoding_rank}
\title{Encode categories as response means}
\usage{
target_encoding_loo(
  df = NULL,
  response = NULL,
  predictor = NULL,
  encoded_name = NULL,
  smoothing = NULL,
  ...
)

target_encoding_mean(
  df = NULL,
  response = NULL,
  predictor = NULL,
  encoded_name = NULL,
  smoothing = 0,
  ...
)

target_encoding_rank(
  df = NULL,
  response = NULL,
  predictor = NULL,
  encoded_name = NULL,
  smoothing = NULL,
  ...
)
}
\arguments{
\item{df}{(required; dataframe, tibble, or sf) A dataframe with responses
(optional) and predictors. Must have at least 10 rows for pairwise
correlation analysis, and \code{10 * (length(predictors) - 1)} for VIF.
Default: NULL.}

\item{response}{(optional, character string) Name of a numeric response variable in \code{df}. Default: NULL.}

\item{predictor}{(required; string) Name of the categorical predictor to encode. Default: NULL}

\item{encoded_name}{(optional, string) Name of the encoded predictor. Default: NULL}

\item{smoothing}{(optional; integer) Groups smaller than this number have their means pulled towards the mean of the response across all cases. Ignored by \code{\link[=target_encoding_rank]{target_encoding_rank()}} and \code{\link[=target_encoding_loo]{target_encoding_loo()}}. Default: 0}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
dataframe
}
\description{
Encode categories as response means
}
\examples{

#  loading example data
data(vi_smol)

#mean encoding
#-------------

df <- target_encoding_mean(
  df = vi_smol,
  response = "vi_numeric",
  predictor = "soil_type", #categorical
  encoded_name = "soil_type_encoded"
)

if(interactive()){

  plot(
    x = df$soil_type_encoded,
    y = df$vi_numeric,
    xlab = "encoded variable",
    ylab = "response"
  )

}


#rank encoding
#----------

df <- target_encoding_rank(
  df = vi_smol,
  response = "vi_numeric",
  predictor = "soil_type",
  encoded_name = "soil_type_encoded"
)

if(interactive()){

  plot(
    x = df$soil_type_encoded,
    y = df$vi_numeric,
    xlab = "encoded variable",
    ylab = "response"
  )

}


#leave-one-out
#-------------

df <- target_encoding_loo(
  df = vi_smol,
  response = "vi_numeric",
  predictor = "soil_type",
  encoded_name = "soil_type_encoded"
)

if(interactive()){

  plot(
    x = df$soil_type_encoded,
    y = df$vi_numeric,
    xlab = "encoded variable",
    ylab = "response"
  )

}

}
\seealso{
Other target_encoding: 
\code{\link{target_encoding_lab}()}

Other target_encoding: 
\code{\link{target_encoding_lab}()}
}
\concept{target_encoding}
