% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{ci_binom}
\alias{ci_binom}
\title{Proportion CI: Binary Variable (2 groups)}
\usage{
ci_binom(x, n, method = "modified wilson", conf.level = 0.95, ...)
}
\arguments{
\item{x}{Number of events of interest or favorable outcomes.}

\item{n}{Total number of events.}

\item{method}{Calculation method: \code{"modified wilson"}, \code{"wilson"},
\code{"agresti-coull"}, and others. See \code{\link[DescTools:BinomCI]{DescTools::BinomCI()}} documentation.}

\item{conf.level}{Confidence level. Default: 0.95.}

\item{...}{Additional parameters for \code{\link[DescTools:BinomCI]{DescTools::BinomCI()}}.
See the documentation for that function.}
}
\value{
A data frame with columns:
\itemize{
\item \code{est} (\verb{<dbl>}) -- proportion estimate;
\item \code{lwr.ci}, \code{upr.ci} (\verb{<dbl>}) -- lower and upper CI bounds;
\item \code{x} (\verb{<int>}) -- number of events of interest;
\item \code{n} (\verb{<int>}) -- total number of events.
}
}
\description{
Calculates confidence intervals (CI) for proportions in binary variables.
This enhanced version of \code{\link[DescTools:BinomCI]{DescTools::BinomCI()}} returns a data frame.
}
\details{
Similar to \code{\link[DescTools:BinomCI]{DescTools::BinomCI()}}, but uses the modified Wilson method by default
and returns a data frame instead of a vector, enabling plotting with \pkg{ggplot2}.
}
\examples{
# Example 1: Survey responses
# 54 out of 80 people agree with a statement
# What is the true proportion of agreement in the population?
ci_binom(x = 54, n = 80)
# Interpretation: We're 95\% confident the true proportion
# is between lwr.ci and upr.ci (roughly 0.57 to 0.78)

# Example 2: Medical treatment success
# 23 out of 30 patients recovered
ci_binom(x = 23, n = 30)

# Example 3: Coin flips
# Testing if a coin is fair: 58 heads in 100 flips
ci_binom(x = 58, n = 100)
# If 0.5 is in the CI, we can't rule out the coin being fair

# Example 4: Effect of sample size
# Same proportion (54/80 is approximately 0.675) but different sample sizes
ci_binom(x = 54, n = c(80, 100, 200, 500))
# Notice: Larger samples give narrower (more precise) CIs

# Example 5: Two separate groups
# Group A: 23 successes, Group B: 45 successes
successes <- c(23, 45)
ci_binom(successes, n = sum(successes))

# Example 6: Student exam pass rates
# 67 out of 85 students passed
ci_binom(x = 67, n = 85)

# Example 7: Different confidence levels
# 90\% confidence (narrower interval, less confident)
ci_binom(x = 54, n = 80, conf.level = 0.90)

# 99\% confidence (wider interval, more confident)
ci_binom(x = 54, n = 80, conf.level = 0.99)

# Example 8: Comparing different methods
ci_binom(x = 15, n = 25, method = "wilson")
ci_binom(x = 15, n = 25, method = "agresti-coull")
# Different methods can give slightly different results

}
