% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_bulk.R
\name{generate_samples}
\alias{generate_samples}
\title{Generate random cell number samples}
\usage{
generate_samples(
  object,
  n,
  equal_sample = TRUE,
  method = c("unif", "dirichlet"),
  alpha = 1.5
)
}
\arguments{
\item{object}{A 'cellMarkers' class object}

\item{n}{Integer value for the number of samples to generate}

\item{equal_sample}{Logical whether to sample subclasses equally or generate
samples with proportions of cells in keeping with the original subtotal of
cells in the main scRNA-Seq data.}

\item{method}{Either "unif" or "dirichlet" to specify whether cell numbers
are drawn from uniform distribution or dirichlet distribution.}

\item{alpha}{Shape parameter for \code{gtools::rdirichlet()}. Automatically
expanded to be a vector whose length is the number of subclasses.}
}
\value{
An integer matrix with \code{n} rows, with columns for each cell
subclasses in \code{object}, representing cell counts for each cell subclass.
Designed to be passed to \code{\link[=simulate_bulk]{simulate_bulk()}}.
}
\description{
Used for simulating pseudo-bulk RNA-Seq from a 'cellMarkers' object. Cell
counts are randomly sampled from the uniform distribution, using the original
subclass contingency table as a limit on the maximum number of cells in each
subclass.
}
\details{
Leaving \code{equal_sample = TRUE} is better for tuning deconvolution parameters.
}
\seealso{
\code{\link[=simulate_bulk]{simulate_bulk()}}
}
