% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covar_sim.R
\name{estimate_covar_model_full_cond}
\alias{estimate_covar_model_full_cond}
\title{Full conditional covariate simulation model}
\usage{
estimate_covar_model_full_cond(data, cond.dist = NULL)
}
\arguments{
\item{data}{Covariate \code{data.table}}

\item{cond.dist}{\code{list} with random generator functions for the conditional
distribution of each covariate}
}
\value{
lava::lvm object with estimated coefficients
}
\description{
Estimates a full conditional model to approximate the joint
distribution of covariate data. Each factor \eqn{p(x_i | x_1, \dots
x_{i-1})} is modelled with a \code{glm}, with mean \eqn{E[x_i | x_1, \dots
x_{i-1}] = g^{-1}(\beta_0 + \sum_{j=1}^{i-1}\beta_j x_j)}. The parametric
distribution of each factor is either derived from the column type (see
\code{\link{derive_covar_distribution}}) or specified by \code{cond.dist}.
}
\examples{
data <- data.table::data.table(
y = as.factor(rbinom(1e3, size = 1, prob=0.1))
)

# infer distribution of y from column type
m.est <- estimate_covar_model_full_cond(data)
y <- sample_covar_parametric_model(1e4, m.est)$y |> as.integer() - 1
print(mean(y))

# specify distribution of y
m.est <- estimate_covar_model_full_cond(
  data, cond.dist = list(y = binomial.lvm)
)
y <- sample_covar_parametric_model(1e4, m.est)$y |> as.integer() - 1
print(mean(y))
}
\author{
Benedikt Sommer
}
