% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/rimplementation.R
\name{integratemvn}
\alias{integratemvn}
\alias{integratemvnR}
\title{Integrate over Multivariate Normal Random Effects}
\usage{
integratemvn(X, k, sd, chol)

integratemvnR(X, k, sd, chol)
}
\arguments{
\item{X}{A numeric matrix of the data to be multiplied by the random effects}

\item{k}{An integer, the number of random samples to be used for numerical integration}

\item{sd}{A numeric vector of the standard deviations}

\item{chol}{A numeric matrix, which should be the Cholesky decomposition of the
correlation matrix of the multivariate normal distribution.}
}
\value{
A numeric matrix with random values
}
\description{
Used in the process of Monte Carlo integration
over multivariate normal random effects. This generates the
random draws from the multivariate normal distribution
and multiplies these by the data.
Not intended to be called directly by most users.
}
\section{Functions}{
\itemize{
\item \code{integratemvnR()}: Pure \code{R} implementation of \code{\link[=integratemvn]{integratemvn()}}.

}}
\examples{
integratemvn(
  X = matrix(1, 1, 2),
  k = 100L,
  sd = c(10, 5),
  chol = chol(matrix(c(1, .5, .5, 1), 2)))

integratemvn(matrix(1, 1, 1), 100L, c(5), matrix(1))
}
