% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{theme_brand_ggplot2}
\alias{theme_brand_ggplot2}
\title{Create a ggplot2 theme using brand colors}
\usage{
theme_brand_ggplot2(
  brand = NULL,
  background = NULL,
  foreground = NULL,
  accent = NULL,
  ...,
  base_size = 11,
  title_size = base_size * 1.2,
  title_color = NULL,
  line_color = NULL,
  rect_fill = NULL,
  text_color = NULL,
  plot_background_fill = NULL,
  panel_background_fill = NULL,
  panel_grid_major_color = NULL,
  panel_grid_minor_color = NULL,
  axis_text_color = NULL,
  plot_caption_color = NULL
)
}
\arguments{
\item{brand}{One of:
\itemize{
\item \code{NULL} (default): Automatically detect and read a _brand.yml file
\item A path to a brand.yml file or directory containing _brand.yml
\item A brand object (as returned by \code{read_brand_yml()} or \code{as_brand_yml()})
\item \code{FALSE}: Don't use a brand file; explicit colors must be provided
}}

\item{background}{The background color, defaults to \code{brand.color.background}.
If provided directly, this value can be a valid R color or the name of a
color in \code{brand.color} or \code{brand.color.palette}.}

\item{foreground}{The foreground color, defaults to \code{brand.color.foreground}.
If provided directly, this value can be a valid R color or the name of a
color in \code{brand.color} or \code{brand.color.palette}.}

\item{accent}{The accent color, defaults to \code{brand.color.primary} or
\code{brand.color.palette.accent}. If provided directly, this value can be a
valid R color or the name of a color in \code{brand.color} or
\code{brand.color.palette}.}

\item{...}{Reserved for future use.}

\item{base_size}{Base font size in points. Used for the \code{size} property of
\code{\link[ggplot2:element]{ggplot2::element_text()}} in the \code{text} theme element.}

\item{title_size}{Title font size in points. Used for the \code{size} property of
\code{\link[ggplot2:element]{ggplot2::element_text()}} in the \code{title} theme element. Defaults to
\code{base_size * 1.2}.}

\item{title_color, }{Color for the \code{color} property of
\code{\link[ggplot2:element]{ggplot2::element_text()}} in the \code{title} theme element. Can be a valid R
color or the name of a color in \code{brand.color} or \code{brand.color.palette}. If
not provided, defaults to the \code{foreground} color.}

\item{line_color}{Color for the \code{color} property of \code{\link[ggplot2:element]{ggplot2::element_line()}}
in the \code{line} theme element. Can be a valid R color or the name of a color
in \code{brand.color} or \code{brand.color.palette}. If not provided, defaults to a
blend of foreground and background colors.}

\item{rect_fill}{Fill color for the \code{fill} property of
\code{\link[ggplot2:element]{ggplot2::element_rect()}} in the \code{rect} theme element. Can be a valid R
color or the name of a color in \code{brand.color} or \code{brand.color.palette}. If
not provided, defaults to the background color.}

\item{text_color}{Color for the \code{color} property of \code{\link[ggplot2:element]{ggplot2::element_text()}}
in the \code{text} theme element. Can be a valid R color or the name of a color
in \code{brand.color} or \code{brand.color.palette}. If not provided, defaults to a
blend of foreground and background colors.}

\item{plot_background_fill}{Fill color for the \code{fill} property of
\code{\link[ggplot2:element]{ggplot2::element_rect()}} in the \code{plot.background} theme element. Can be a
valid R color or the name of a color in \code{brand.color} or
\code{brand.color.palette}. If not provided, defaults to the background color.}

\item{panel_background_fill}{Fill color for the \code{fill} property of
\code{\link[ggplot2:element]{ggplot2::element_rect()}} in the \code{panel.background} theme element. Can be a
valid R color or the name of a color in \code{brand.color} or
\code{brand.color.palette}. If not provided, defaults to the background color.}

\item{panel_grid_major_color}{Color for the \code{color} property of
\code{\link[ggplot2:element]{ggplot2::element_line()}} in the \code{panel.grid.major} theme element. Can be a
valid R color or the name of a color in \code{brand.color} or
\code{brand.color.palette}. If not provided, defaults to a blend of foreground
and background colors.}

\item{panel_grid_minor_color}{Color for the \code{color} property of
\code{\link[ggplot2:element]{ggplot2::element_line()}} in the \code{panel.grid.minor} theme element. Can be a
valid R color or the name of a color in \code{brand.color} or
\code{brand.color.palette}. If not provided, defaults to a blend of foreground
and background colors.}

\item{axis_text_color}{Color for the \code{color} property of
\code{\link[ggplot2:element]{ggplot2::element_text()}} in the \code{axis.text} theme element. Can be a valid
R color or the name of a color in \code{brand.color} or \code{brand.color.palette}.
If not provided, defaults to a blend of foreground and background colors.}

\item{plot_caption_color}{Color for the \code{color} property of
\code{\link[ggplot2:element]{ggplot2::element_text()}} in the \code{plot.caption} theme element. Can be a
valid R color or the name of a color in \code{brand.color} or
\code{brand.color.palette}. If not provided, defaults to a blend of foreground
and background colors.}
}
\value{
A \code{\link[ggplot2:theme]{ggplot2::theme()}} object.
}
\description{
Create a ggplot2 theme using explicit colors or by automatically extracting
colors from a \strong{brand.yml} file.
}
\section{Branded Theming}{

The \verb{theme_brand_*} functions can be used in two ways:
\enumerate{
\item \strong{With a brand.yml file}: The \verb{theme_brand_*} functions use
\code{\link[=read_brand_yml]{read_brand_yml()}} to automatically detect and use a \verb{_brand.yml} file in
your current project. You can also explicitly pass a path to a brand.yml
file or a brand object (as returned by \code{\link[=read_brand_yml]{read_brand_yml()}} or created with
\code{\link[=as_brand_yml]{as_brand_yml()}}). When a \code{brand} is provided, the theme functions will
use the colors defined in the brand file automatically.
\item \strong{With explicit colors}: You can directly provide colors to override the
default brand colors, or you can use \code{brand = FALSE} to ignore any project
\verb{_brand.yml} files and only use the explicitly provided colors.
}
}

\examples{
\dontshow{if (rlang::is_installed("ggplot2")) withAutoprint(\{ # examplesIf}
brand <- as_brand_yml('
color:
  palette:
    black: "#1A1A1A"
    white: "#F9F9F9"
    orange: "#FF6F20"
  foreground: black
  background: white
  primary: orange')

library(ggplot2)
ggplot(diamonds, aes(carat, price)) +
  geom_point() +
  theme_brand_ggplot2(brand)
\dontshow{\}) # examplesIf}
}
\seealso{
Other branded theming functions: 
\code{\link{theme_brand_flextable}()},
\code{\link{theme_brand_gt}()},
\code{\link{theme_brand_plotly}()},
\code{\link{theme_brand_thematic}()}
}
\concept{branded theming functions}
