% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadrature_and_differentiation.R
\name{numerical_integration}
\alias{numerical_integration}
\alias{trapezoidal}
\alias{gauss_legendre}
\alias{gauss_kronrod}
\title{Numerical Integration}
\usage{
trapezoidal(f, a, b, tol = sqrt(.Machine$double.eps), max_refinements = 12)

gauss_legendre(f, a, b, points = 7)

gauss_kronrod(
  f,
  a,
  b,
  points = 15,
  max_depth = 15,
  tol = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{f}{A function to integrate. It should accept a single numeric value and return a single numeric value.}

\item{a}{The lower limit of integration.}

\item{b}{The upper limit of integration.}

\item{tol}{The tolerance for the approximation. Default is \code{sqrt(.Machine$double.eps)}.}

\item{max_refinements}{The maximum number of refinements to apply. Default is 12.}

\item{points}{The number of evaluation points to use in the Gauss-Legendre or Gauss-Kronrod quadrature.}

\item{max_depth}{Sets the maximum number of interval splittings for Gauss-Kronrod permitted before stopping. Set this to zero for non-adaptive quadrature.}
}
\value{
A single numeric value with the computed integral.
}
\description{
Functions for numerical integration using various methods such as trapezoidal rule, Gauss-Legendre quadrature, and Gauss-Kronrod quadrature.
}
\examples{
# Trapezoidal rule integration of sin(x) from 0 to pi
trapezoidal(sin, 0, pi)
# Gauss-Legendre integration of exp(x) from 0 to 1
gauss_legendre(exp, 0, 1, points = 7)
# Adaptive Gauss-Kronrod integration of log(x) from 1 to 2
gauss_kronrod(log, 1, 2, points = 15, max_depth = 10)
}
