% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolators.R
\name{makima}
\alias{makima}
\title{Modified Akima Interpolator}
\usage{
makima(x, y, left_endpoint_derivative = NULL, right_endpoint_derivative = NULL)
}
\arguments{
\item{x}{Numeric vector of abscissas (x-coordinates).}

\item{y}{Numeric vector of ordinates (y-coordinates).}

\item{left_endpoint_derivative}{Optional numeric value of the derivative at the left endpoint.}

\item{right_endpoint_derivative}{Optional numeric value of the derivative at the right endpoint.}
}
\value{
An object of class \code{makima} with methods:
\itemize{
\item \code{interpolate(xi)}: Evaluate the interpolator at point \code{xi}.
\item \code{prime(xi)}: Evaluate the derivative of the interpolator at point \code{xi}.
\item \code{push_back(x, y)}: Add a new control point
}
}
\description{
Constructs a Modified Akima interpolator given the vectors of abscissas, ordinates, and derivatives.
}
\examples{
x <- c(0, 1, 2, 3)
y <- c(0, 1, 0, 1)
interpolator <- makima(x, y)
xi <- 0.5
interpolator$interpolate(xi)
interpolator$prime(xi)
interpolator$push_back(4, 1)
}
