% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_regression.R
\name{linear_regression}
\alias{linear_regression}
\alias{simple_ordinary_least_squares}
\alias{simple_ordinary_least_squares_with_R_squared}
\title{Linear Regression Functions}
\usage{
simple_ordinary_least_squares(x, y)

simple_ordinary_least_squares_with_R_squared(x, y)
}
\arguments{
\item{x}{A numeric vector.}

\item{y}{A numeric vector.}
}
\value{
A two-element numeric vector containing the intercept and slope of the regression line,
or a three-element vector containing the intercept, slope, and R-squared value if applicable.
}
\description{
Functions to perform linear regression.
}
\examples{
# Simple Ordinary Least Squares
x <- c(1, 2, 3, 4, 5)
y <- c(2, 3, 5, 7, 11)
simple_ordinary_least_squares(x, y)
# Simple Ordinary Least Squares with R-squared
simple_ordinary_least_squares_with_R_squared(x, y)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/linear_regression.html}{Boost Documentation} for more details on the mathematical background.
}
