% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/laplace_distribution.R
\name{laplace_distribution}
\alias{laplace_distribution}
\alias{laplace_pdf}
\alias{laplace_lpdf}
\alias{laplace_cdf}
\alias{laplace_lcdf}
\alias{laplace_quantile}
\title{Laplace Distribution Functions}
\usage{
laplace_pdf(x, location = 0, scale = 1)

laplace_lpdf(x, location = 0, scale = 1)

laplace_cdf(x, location = 0, scale = 1)

laplace_lcdf(x, location = 0, scale = 1)

laplace_quantile(p, location = 0, scale = 1)
}
\arguments{
\item{x}{quantile}

\item{location}{location parameter (default is 0)}

\item{scale}{scale parameter (default is 1)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Laplace distribution.
}
\examples{
# Laplace distribution with location = 0, scale = 1
laplace_pdf(0)
laplace_lpdf(0)
laplace_cdf(0)
laplace_lcdf(0)
laplace_quantile(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/laplace_dist.html}{Boost Documentation} for more details on the mathematical background.
}
