% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperexponential_distribution.R
\name{hyperexponential_distribution}
\alias{hyperexponential_distribution}
\alias{hyperexponential_pdf}
\alias{hyperexponential_lpdf}
\alias{hyperexponential_cdf}
\alias{hyperexponential_lcdf}
\alias{hyperexponential_quantile}
\title{Hyperexponential Distribution Functions}
\usage{
hyperexponential_pdf(x, probabilities, rates)

hyperexponential_lpdf(x, probabilities, rates)

hyperexponential_cdf(x, probabilities, rates)

hyperexponential_lcdf(x, probabilities, rates)

hyperexponential_quantile(p, probabilities, rates)
}
\arguments{
\item{x}{quantile}

\item{probabilities}{vector of probabilities (sum must be 1)}

\item{rates}{vector of rates (all rates must be > 0)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Hyperexponential distribution.
}
\examples{
# Hyperexponential distribution with probabilities = c(0.5, 0.5) and rates = c(1, 2)
hyperexponential_pdf(2, c(0.5, 0.5), c(1, 2))
hyperexponential_lpdf(2, c(0.5, 0.5), c(1, 2))
hyperexponential_cdf(2, c(0.5, 0.5), c(1, 2))
hyperexponential_lcdf(2, c(0.5, 0.5), c(1, 2))
hyperexponential_quantile(0.5, c(0.5, 0.5), c(1, 2))
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/hyperexponential_dist.html}{Boost Documentation} for more details on the mathematical background.
}
