% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_distribution.R
\name{gamma_distribution}
\alias{gamma_distribution}
\alias{gamma_pdf}
\alias{gamma_lpdf}
\alias{gamma_cdf}
\alias{gamma_lcdf}
\alias{gamma_quantile}
\title{Gamma Distribution Functions}
\usage{
gamma_pdf(x, shape, scale)

gamma_lpdf(x, shape, scale)

gamma_cdf(x, shape, scale)

gamma_lcdf(x, shape, scale)

gamma_quantile(p, shape, scale)
}
\arguments{
\item{x}{quantile}

\item{shape}{shape parameter (shape > 0)}

\item{scale}{scale parameter (scale > 0)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Gamma distribution.
}
\examples{
# Gamma distribution with shape = 3, scale = 4
gamma_pdf(2, 3, 4)
gamma_lpdf(2, 3, 4)
gamma_cdf(2, 3, 4)
gamma_lcdf(2, 3, 4)
gamma_quantile(0.5, 3, 4)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/gamma_dist.html}{Boost Documentation} for more details on the mathematical background.
}
