% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisher_f_distribution.R
\name{fisher_f_distribution}
\alias{fisher_f_distribution}
\alias{fisher_f_pdf}
\alias{fisher_f_lpdf}
\alias{fisher_f_cdf}
\alias{fisher_f_lcdf}
\alias{fisher_f_quantile}
\title{Fisher F Distribution Functions}
\usage{
fisher_f_pdf(x, df1, df2)

fisher_f_lpdf(x, df1, df2)

fisher_f_cdf(x, df1, df2)

fisher_f_lcdf(x, df1, df2)

fisher_f_quantile(p, df1, df2)
}
\arguments{
\item{x}{quantile}

\item{df1}{degrees of freedom for the numerator (df1 > 0)}

\item{df2}{degrees of freedom for the denominator (df2 > 0)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Fisher F distribution.
}
\examples{
# Fisher F distribution with df1 = 5, df2 = 2
fisher_f_pdf(1, 5, 2)
fisher_f_lpdf(1, 5, 2)
fisher_f_cdf(1, 5, 2)
fisher_f_lcdf(1, 5, 2)
fisher_f_quantile(0.5, 5, 2)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/f_dist.html}{Boost Documentation} for more details on the mathematical background.
}
