% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorials_and_binomial_coefficients.R
\name{factorials_and_binomial_coefficients}
\alias{factorials_and_binomial_coefficients}
\alias{factorial_boost}
\alias{unchecked_factorial}
\alias{max_factorial}
\alias{double_factorial}
\alias{rising_factorial}
\alias{falling_factorial}
\alias{binomial_coefficient}
\title{Factorials and Binomial Coefficients}
\usage{
factorial_boost(i)

unchecked_factorial(i)

max_factorial()

double_factorial(i)

rising_factorial(x, i)

falling_factorial(x, i)

binomial_coefficient(n, k)
}
\arguments{
\item{i}{Non-negative integer input for factorials and double factorials.}

\item{x}{Base value for rising and falling factorials.}

\item{n}{Total number of elements for binomial coefficients.}

\item{k}{Number of elements to choose for binomial coefficients.}
}
\value{
A single numeric value with the computed factorial, double factorial, rising factorial, falling factorial, or binomial coefficient.
}
\description{
Functions to compute factorials, double factorials, rising and falling factorials, and binomial coefficients.
}
\examples{
# Factorial of 5
factorial_boost(5)
# Unchecked factorial of 5 (using table lookup)
unchecked_factorial(5)
# Maximum factorial value that can be computed
max_factorial()
# Double factorial of 6
double_factorial(6)
# Rising factorial of 3 with exponent 2
rising_factorial(3, 2)
# Falling factorial of 3 with exponent 2
falling_factorial(3, 2)
# Binomial coefficient "5 choose 2"
binomial_coefficient(5, 2)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/factorials.html}{Boost Documentation} for more details on the mathematical background.
}
