% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blas_extras.R
\name{dqddot}
\alias{dqddot}
\title{High-accuracy dot product}
\usage{
dqddot(N = NULL, X, INCX = 1L, Y, INCY = 1L)
}
\arguments{
\item{N}{Optional integer giving the number of elements. Defaults to `length(X)`.}

\item{X}{Double-precision vector, matrix or [`bigmemory::big.matrix`] input.}

\item{INCX}{Integer stride for traversing `X`.}

\item{Y}{Double-precision object updated in place.}

\item{INCY}{Integer stride for traversing `Y`.}
}
\value{
Numeric scalar equal to the dot product of `X` and `Y`.
}
\description{
Forms the dot product using long-double accumulation to mitigate rounding error.
}
\examples{
dqddot(X = 1:3, Y = c(2, 4, 6))

}
