% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_interface.R
\name{svd_bigmatrix}
\alias{svd_bigmatrix}
\title{Singular value decomposition for \code{bigmemory::big.matrix} inputs}
\usage{
svd_bigmatrix(
  xpMat,
  nu = -1L,
  nv = -1L,
  block_size = 1024L,
  method = c("dgesdd", "dgesvd")
)
}
\arguments{
\item{xpMat}{Either a \code{\link[bigmemory:big.matrix]{bigmemory::big.matrix}} or an external pointer such
as \code{mat@address} that references the source \code{big.matrix}.}

\item{nu}{Number of left singular vectors to return. Use a negative value to
request the default of \code{min(nrow, ncol)} vectors and zero to skip
returning \code{u} entirely.}

\item{nv}{Number of right singular vectors to return. Use a negative value to
request the default of \code{min(nrow, ncol)} vectors and zero to skip
returning \code{v} entirely.}

\item{block_size}{Number of rows to process per block when streaming data
into BLAS kernels. Larger values can improve throughput at the cost of
additional temporary memory.}

\item{method}{LAPACK backend used to compute the decomposition. The default
uses the divide-and-conquer routine \code{dgesdd} and falls back to \code{dgesvd}
when required.}
}
\value{
A list with components \code{u}, \code{d}, and \code{v} analogous to base R's
\code{\link[=svd]{svd()}} output. When \code{nu} or \code{nv} are zero the corresponding matrix has
zero columns.
}
\description{
Compute the singular value decomposition (SVD) of a
\code{\link[bigmemory:big.matrix]{bigmemory::big.matrix}} without materialising it as a base R matrix.
Blocks of rows are streamed through BLAS before LAPACK is invoked so that
even moderately large matrices can be decomposed efficiently.
}
\examples{
\dontshow{if (requireNamespace("bigmemory", quietly = TRUE)) withAutoprint(\{ # examplesIf}
set.seed(42)
mat <- bigmemory::as.big.matrix(matrix(rnorm(20), nrow = 5))
svd_res <- svd_bigmatrix(mat, nu = 2, nv = 2)
svd_res$d
\dontshow{\}) # examplesIf}
}
