% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{heatmap_argo}
\alias{heatmap_argo}
\title{Heatmap plot of ARGO coefficients applied on CDC's ILI data}
\usage{
heatmap_argo(argo_coef, lim = 0.1, na.grey = TRUE, scale = 1)
}
\arguments{
\item{argo_coef}{The coefficient matrix}

\item{lim}{the limit to truncate for large coefficients for better presentation}

\item{na.grey}{whether to plot grey for NA values}

\item{scale}{margin scale}
}
\value{
a graph on the default plot window
}
\description{
Heatmap plot of ARGO coefficients applied on CDC's ILI data
}
\examples{
cor_coef <- matrix(runif(100, -1, 1), ncol=10)
colnames(cor_coef) <- as.character(Sys.Date() - 10:1)
rownames(cor_coef) <- paste0("row", 1:10)
pdf(file.path(tempdir(), "heatmap_argo.pdf"), height=11,width=12)
heatmap_argo(cor_coef)
dev.off()

}
