% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portal-resources.R
\name{arc_portal_resources}
\alias{arc_portal_resources}
\title{Portal File Resources}
\usage{
arc_portal_resources(
  id = arc_portal_self(token)[["id"]],
  page_size = 50,
  max_pages = Inf,
  .progress = TRUE,
  host = arc_host(),
  token = arc_token()
)
}
\arguments{
\item{id}{the portal ID. By default it fetches the \code{id} from \code{\link[=arc_portal_self]{arc_portal_self()}}.}

\item{page_size}{a scalar integer between 1 and 100 indicating the number of responses per page.}

\item{max_pages}{the maximum number of pages to fetch. By default fetches all pages.}

\item{.progress}{default \code{TRUE}. Whether to display a progress bar for requests.}

\item{host}{default \code{"https://www.arcgis.com"}. The host of your ArcGIS Portal.}

\item{token}{an object of class \code{httr2_token} as generated by \code{\link[=auth_code]{auth_code()}}
or related function}
}
\value{
a data.frame of resources available to your portal.
}
\description{
The resources endpoint lists all file resources for the organization.
}
\examples{
\dontrun{
  set_arc_token(auth_user())
  arc_portal_resources()
}

}
\references{
\href{https://developers.arcgis.com/rest/users-groups-and-items/resources-portal/}{API Reference}
}
\seealso{
Other portal: 
\code{\link{arc_portal_urls}()},
\code{\link{arc_portal_users}()},
\code{\link{self}}
}
\concept{portal}
