% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aclhs_plot.R
\name{aclhs.plot_sampling_distribution}
\alias{aclhs.plot_sampling_distribution}
\title{Plots the acLHS samples distribution.}
\usage{
aclhs.plot_sampling_distribution(df, aclhs_samples, plot_params)
}
\arguments{
\item{df}{The original data in dataframe format}

\item{aclhs_samples}{The acLHS-derived sample indices}

\item{plot_params}{The plotting parameters to use}
}
\value{
No return value, called for side effects
}
\description{
Plots the acLHS sample distribution for either 1D or 2D data.
acLHS samples will be overlayed over the original data points in blue.
}
\examples{
## Get the data of interest and get the acLHS sample indices
data(ex_data_2D)
input2D <- ex_data_2D
aclhs_sam <- aclhs(df=input2D, num_samples=50, weights=c(1,1,1), iter=100)

## Set plotting parameters
p_params <- aclhs.plot_params(file_name=tempfile(fileext=".png"),
                              xlab=expression(bold("X [km]")),
                              ylab=expression(bold("Y [km]")))

## Create plot
aclhs.plot_sampling_distribution(df=input2D, aclhs_samples=aclhs_sam,
                                 plot_params=p_params)
}
