% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R
\name{sort.multiPhylo}
\alias{sort.multiPhylo}
\alias{==.phylo}
\alias{<.phylo}
\alias{>.phylo}
\alias{==.MixedBase}
\alias{<.MixedBase}
\alias{>.MixedBase}
\title{Sort a list of phylogenetic trees}
\usage{
\method{sort}{multiPhylo}(x, decreasing = FALSE, na.last = NA, ...)

\method{==}{phylo}(e1, e2)

\method{<}{phylo}(e1, e2)

\method{>}{phylo}(e1, e2)

\method{==}{MixedBase}(e1, e2)

\method{<}{MixedBase}(e1, e2)

\method{>}{MixedBase}(e1, e2)
}
\arguments{
\item{x, decreasing, na.last, \dots}{As in \code{\link[=sort]{sort()}}.}

\item{e1, e2}{Objects to be compared.}
}
\description{
Trees are sorted by their \link[=TreeNumber]{mixed base representation},
treating their leaves in the order of their labels (i.e. alphabetically,
if leaves are labelled with text).
}
\examples{
sort(as.phylo(5:0, 7))
}
\seealso{
Other utility functions: 
\code{\link{ClusterTable}},
\code{\link{ClusterTable-methods}},
\code{\link{Hamming}()},
\code{\link{MSTEdges}()},
\code{\link{SampleOne}()},
\code{\link{TipTimedTree}()},
\code{\link{UnshiftTree}()},
\code{\link{as.multiPhylo}()},
\code{\link{match,phylo,phylo-method}},
\code{\link{sapply64}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{utility functions}
