% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_properties.R
\name{NSplits}
\alias{NSplits}
\alias{NPartitions}
\alias{NSplits.phylo}
\alias{NSplits.list}
\alias{NSplits.multiPhylo}
\alias{NSplits.Splits}
\alias{NSplits.numeric}
\alias{NSplits.NULL}
\alias{NSplits.ClusterTable}
\alias{NSplits.character}
\title{Number of distinct splits}
\usage{
NSplits(x)

NPartitions(x)

\method{NSplits}{phylo}(x)

\method{NSplits}{list}(x)

\method{NSplits}{multiPhylo}(x)

\method{NSplits}{Splits}(x)

\method{NSplits}{numeric}(x)

\method{NSplits}{`NULL`}(x)

\method{NSplits}{ClusterTable}(x)

\method{NSplits}{character}(x)
}
\arguments{
\item{x}{A phylogenetic tree of class \code{phylo}; a list of such trees
(of class \code{list} or \code{multiPhylo}); a \code{Splits} object;
a vector of integers; or a character vector listing tips of a tree,
or a character of length one specifying a tree in Newick format.}
}
\value{
\code{NSplits()} returns an integer specifying the number of bipartitions in
the specified objects, or in a binary tree with \code{x} tips.
}
\description{
\code{NSplits()} counts the unique bipartition splits in a tree or object.
}
\examples{
NSplits(8L)
NSplits(PectinateTree(8))
NSplits(as.Splits(BalancedTree(8)))
}
\seealso{
Other tree properties: 
\code{\link{Cherries}()},
\code{\link{ConsensusWithout}()},
\code{\link{LongBranch}()},
\code{\link{MatchEdges}()},
\code{\link{NTip}()},
\code{\link{NodeNumbers}()},
\code{\link{PathLengths}()},
\code{\link{SplitsInBinaryTree}()},
\code{\link{TipLabels}()},
\code{\link{TreeIsRooted}()},
\code{\link{Treeness}()}

Other Splits operations: 
\code{\link{LabelSplits}()},
\code{\link{NTip}()},
\code{\link{PolarizeSplits}()},
\code{\link{SplitFrequency}()},
\code{\link{Splits}},
\code{\link{SplitsInBinaryTree}()},
\code{\link{TipLabels}()},
\code{\link{TipsInSplits}()},
\code{\link{match,Splits,Splits-method}},
\code{\link{xor}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{Splits operations}
\concept{tree properties}
