% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_descendants.R
\name{NDescendants}
\alias{NDescendants}
\title{Count descendants for each node in a tree}
\usage{
NDescendants(tree)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}
}
\value{
\code{NDescendants()} returns an integer listing the number of direct
descendants (leaves or internal nodes) for each node in a tree.
}
\description{
\code{NDescendants()} counts the number of nodes (including leaves) directly
descended from each node in a tree.
}
\examples{
tree <- CollapseNode(BalancedTree(8), 12:15)
NDescendants(tree)
plot(tree)
nodelabels(NDescendants(tree))

}
\seealso{
Other tree navigation: 
\code{\link{AncestorEdge}()},
\code{\link{CladeSizes}()},
\code{\link{DescendantEdges}()},
\code{\link{EdgeAncestry}()},
\code{\link{EdgeDistances}()},
\code{\link{ListAncestors}()},
\code{\link{MRCA}()},
\code{\link{MatchEdges}()},
\code{\link{NodeDepth}()},
\code{\link{NodeNumbers}()},
\code{\link{NodeOrder}()},
\code{\link{RootNode}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree navigation}
