% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Decompose.R
\name{Decompose}
\alias{Decompose}
\title{Decompose additive (ordered) phylogenetic characters}
\usage{
Decompose(dataset, indices)
}
\arguments{
\item{dataset}{A phylogenetic data matrix of \pkg{phangorn} class \code{phyDat},
whose names correspond to the labels of any accompanying tree.}

\item{indices}{Integer or logical vector specifying indices of characters
that should be decomposed}
}
\value{
\code{Decompose()} returns a \code{phyDat} object in which the specified
ordered characters have been decomposed into binary characters.
The attribute \code{originalIndex} lists the index of the character in
\code{dataset} to which each element corresponds.
}
\description{
\code{Decompose()} decomposes additive characters into a series of binary
characters, which is mathematically equivalent when analysed under
equal weights parsimony.  (This equivalence is not exact
under implied weights or under probabilistic tree inference methods.)
}
\details{
An ordered (additive) character can be rewritten as a mathematically
equivalent hierarchy of binary neomorphic characters
\insertCite{Farris1970}{TreeTools}.
Two reasons to prefer the latter approach are:
\itemize{
\item It makes explicit the evolutionary assumptions underlying an ordered
character, whether the underlying ordering is linear, reticulate or
branched \insertCite{Mabee1989}{TreeTools}.
\item It avoids having to identify characters requiring special treatment to
phylogenetic software, which requires the maintenance of an up-to-date
log of which characters are treated as additive and which sequence their
states occur in, a step that may be overlooked by re-users of the data.
}

Careful consideration is warranted when evaluating whether a group of
related characteristics ought to be treated as ordered
\insertCite{Wilkinson1992}{TreeTools}.
On the one hand, the 'principle of indifference' states that we should treat
all transformations as equally probable (/ surprising / informative);
ordered characters fail this test, as larger changes are treated as less
probable than smaller ones.
On the other hand, ordered characters allow more opportunities for homology
of different character states, and might thus be defended under the auspices
of Hennig’s Auxiliary Principle \insertCite{Wilkinson1992}{TreeTools}.

For a case study of how ordering phylogenetic characters can affect
phylogenetic outcomes in practice, see
\insertCite{Brady2024;textual}{TreeTools}.
}
\examples{
data("Lobo")

# Identify character 11 as additive
# Character 11 will be replaced with two characters
# The present codings 0, 1 and 2 will be replaced with 00, 10, and 11.
decomposed <- Decompose(Lobo.phy, 11)

NumberOfChars <- function(x) sum(attr(x, "weight"))
NumberOfChars(Lobo.phy)   # 115 characters in original
NumberOfChars(decomposed) # 116 characters in decomposed
}
\references{
\insertAllCited{}
}
\seealso{
Other phylogenetic matrix conversion functions: 
\code{\link{MatrixToPhyDat}()},
\code{\link{Reweight}()},
\code{\link{StringToPhyDat}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{phylogenetic matrix conversion functions}
