% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_distance_mast.R
\name{MASTSize}
\alias{MASTSize}
\alias{MASTInfo}
\title{Maximum Agreement Subtree size}
\usage{
MASTSize(tree1, tree2 = tree1, rooted = TRUE)

MASTInfo(tree1, tree2 = tree1, rooted = TRUE)
}
\arguments{
\item{tree1, tree2}{Trees of class \code{phylo}, or lists of such trees to undergo
pairwise comparison.}

\item{rooted}{Logical specifying whether to treat the trees as rooted.}
}
\value{
\code{MASTSize()} returns an integer specifying the number of leaves in
the maximum agreement subtree.

\code{MASTInfo()} returns a vector or matrix listing the phylogenetic
information content, in bits, of the maximum agreement subtree.
}
\description{
Calculate the size or phylogenetic information content
\insertCite{Steel2006}{TreeDist}
of the maximum agreement subtree between two phylogenetic trees, i.e.
the largest tree that can be obtained from both \code{tree1} and \code{tree2} by
deleting, but not rearranging, leaves, using the algorithm of
\insertCite{Valiente2009;textual}{TreeDist}.
}
\details{
Implemented for trees with up to 4096 tips.  Contact the maintainer if you
need to process larger trees.
}
\examples{
 # for as.phylo, BalancedTree, PectinateTree:
library("TreeTools", quietly = TRUE)

MASTSize(PectinateTree(8), BalancedTree(8))
MASTInfo(PectinateTree(8), BalancedTree(8))

MASTSize(BalancedTree(7), as.phylo(0:3, 7))
MASTSize(as.phylo(0:3, 7), PectinateTree(7))

MASTInfo(BalancedTree(7), as.phylo(0:3, 7))
MASTInfo(as.phylo(0:3, 7), PectinateTree(7))

MASTSize(list(Bal = BalancedTree(7), Pec = PectinateTree(7)),
         as.phylo(0:3, 7))
MASTInfo(list(Bal = BalancedTree(7), Pec = PectinateTree(7)),
         as.phylo(0:3, 7))

CompareAll(as.phylo(0:4, 8), MASTSize)
CompareAll(as.phylo(0:4, 8), MASTInfo)
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[phangorn:mast]{phangorn::mast()}}, a slower implementation that also lists the
leaves contained within the subtree.

Other tree distances: 
\code{\link{HierarchicalMutualInfo}()},
\code{\link{JaccardRobinsonFoulds}()},
\code{\link{KendallColijn}()},
\code{\link{MatchingSplitDistance}()},
\code{\link{NNIDist}()},
\code{\link{NyeSimilarity}()},
\code{\link{PathDist}()},
\code{\link{Robinson-Foulds}},
\code{\link{SPRDist}()},
\code{\link{TreeDistance}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree distances}
