% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survivalExtrapolatePlot.R
\name{survivalExtrapolatePlot}
\alias{survivalExtrapolatePlot}
\title{Plot survival data and elicited extrapolated intervals}
\usage{
survivalExtrapolatePlot(
  survDf,
  myfit1,
  myfit2 = NULL,
  fqDist1 = "best",
  fqDist2 = NULL,
  tTruncate = max(survDf$time),
  tTarget,
  alpha = 0.95,
  useWeights = FALSE,
  groups = levels(survDf$treatment),
  xl = "Time (t)",
  fontsize = 12,
  breakTime = NULL,
  showPlot = TRUE,
  returnPlot = FALSE
)
}
\arguments{
\item{survDf}{data frame with individual patient data. Needs three columns with names
"time", "event" and "treatment" (in that order). For weighted observations (e.g. 
using propensity scores), include a fourth column "weights".
Values in the "event" column should be 0 for a censored observation, and 1 otherwise.
The "treatment" column should be included even if there is only one treatment group, and defined
as a factor variable.}

\item{myfit1}{object of class \code{elicitation}, obtained from \code{fitdist} function with
elicited judgements for the first treatment group.}

\item{myfit2}{object of class \code{elicitation}, obtained from \code{fitdist} function with
elicited judgements for the second treatment group, if there is on.}

\item{fqDist1}{fitted distribution family for first treatment group. Options are
\code{"normal"}, \code{"t"}, \code{"skewnormal"}, \code{"gamma"}, \code{"lognormal"},
\code{"logt"},\code{"beta"}, \code{"mirrorgamma"},
\code{"mirrorlognormal"}, \code{"mirrorlogt"} \code{"hist"} (for a histogram fit), and
\code{"best"} (for best fitting)}

\item{fqDist2}{fitted distribution family for second treatment group if there is one. Options are
\code{"normal"}, \code{"t"}, \code{"skewnormal"}, \code{"gamma"}, \code{"lognormal"},
\code{"logt"},\code{"beta"}, \code{"mirrorgamma"},
\code{"mirrorlognormal"}, \code{"mirrorlogt"} \code{"hist"} (for a histogram fit), and
\code{"best"} (for best fitting)}

\item{tTruncate}{Optional argument to censor all observations at this time point.}

\item{tTarget}{Target time for extrapolation: judgements are elicited at S(t = tTarget)}

\item{alpha}{Size of probability interval to plot (100*\code{alpha}\% interval).}

\item{useWeights}{set to TRUE if survDf includes column of weights, as described in specification 
of survDf. This column is passed on to survival::survfit() as the case weights.}

\item{groups}{Vector of strings for the group labels. Will be extracted from factor levels of
\code{treatment} column in \code{survDf}.}

\item{xl}{x-axis label in plot}

\item{fontsize}{font size in plot}

\item{breakTime}{Optional argument to specify tick mark spacing on x-axis}

\item{showPlot}{set to TRUE to display the plot}

\item{returnPlot}{set to TRUE to return the plot as a ggplot object.}
}
\value{
a ggplot object, if returnPlot is TRUE
}
\description{
Show Kaplan-Meier plot of available data, and credible
interval for extrapolated survivor function value S(T)
}
\examples{
\dontrun{
sdf <- survival::veteran[, c("time", "status", "trt")]
colnames(sdf) <- c("time", "event", "treatment")
sdf$treatment <- factor(sdf$treatment, labels = c("standard", "test"))

sdf <- survival::veteran[, c("time", "status", "trt")]
colnames(sdf) <- c("time", "event", "treatment")
sdf$treatment <- factor(sdf$treatment, labels = c("standard", "test"))
groupStandardElicitation <- fitdist(vals = c(0.15, 0.2, 0.25),
                                    probs = c(0.25, 0.5, 0.75),
                                    lower = 0,
                                    upper = 1)

groupTestElicitation <- fitdist(vals = c(0.1, 0.15, 0.2),
                                probs = c(0.25, 0.5, 0.75),
                                lower = 0,
                                upper = 1)

survivalExtrapolatePlot(sdf,
                        myfit1 = groupStandardElicitation,
                        myfit2 = groupTestElicitation,
                        fqDist1 = "beta",
                        fqDist2 = "beta",
                        tTruncate = 150,
                        tTarget=200,
                        alpha = 0.95)
}
}
