% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{evaluate_fuzzy_system}
\alias{evaluate_fuzzy_system}
\title{evaluate the fuzzy system from a fit on some given data}
\usage{
evaluate_fuzzy_system(fs, data, params, verbose = FALSE)
}
\arguments{
\item{fs}{the fuzzy system to evaluate (as a named list)}

\item{data}{the data to evaluate the fuzzy system on}

\item{params}{the fuzzycoco parameters. probably not needed...}

\item{verbose}{whether to be verbose}
}
\value{
the evaluation as a named list:
\itemize{
\item fitness: the fitness value
\item metrics: the evaluation metrics as a named list
}
}
\description{
evaluate the fuzzy system from a fit on some given data
}
\examples{
model <- fuzzycoco("regression", example_mtcars()$params, seed = 123)
x <- mtcars[c("mpg", "hp", "wt")]
y <- mtcars["qsec"]
fit <- fit_xy(model, x, y, progress = FALSE)

res <- evaluate_fuzzy_system(fit$fuzzy_system, cbind(x, y), fit$params)
print(res$metrics$rmse)
}
