% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmf.R
\name{vmf}
\alias{vmf}
\alias{dvmf}
\alias{rvmf}
\title{von Mises-Fisher distribution}
\usage{
dvmf(x, mu, kappa, log = FALSE)

rvmf(n, mu, kappa)
}
\arguments{
\item{x}{unit vector or matrix (with each row being a unit vector) of evaluation points}

\item{mu}{unit mean vector}

\item{kappa}{non-negative numeric value for the concentration parameter of the distribution.}

\item{log}{logical; if \code{TRUE}, densities are returned on the log scale.}

\item{n}{number of random values to return.}
}
\value{
\code{dvmf} gives the density and \code{rvm} generates random deviates.
}
\description{
Density, distribution function, and random generation for the von Mises-Fisher distribution.
}
\details{
This implementation of \code{dvmf} allows for automatic differentiation with \code{RTMB}. \code{rvmf} is a reparameterised import from \code{movMF::rmovMF}.
}
\examples{
set.seed(123)
# single parameter set
mu <- rep(1, 3) / sqrt(3)
kappa <- 4
x <- rvmf(1, mu, kappa)
d <- dvmf(x, mu, kappa)

# vectorised over parameters
mu <- matrix(mu, nrow = 1)
mu <- mu[rep(1,10), ]
kappa <- rep(kappa, 10)
x <- rvmf(10, mu, kappa)
d <- dvmf(x, mu, kappa)
}
