% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CePa-helper.R
\name{getCePaPathwayCatalogue}
\alias{getCePaPathwayCatalogue}
\title{Get KEGG pathway catalogue (network) for CePa.ORA and CePa.GSA methods}
\usage{
getCePaPathwayCatalogue(org = "hsa", updateCache = FALSE)
}
\arguments{
\item{org}{The organism abbreviation. E.g, hsa, mmu, dme, etc.
To see the full list of supported organisms, visit https://www.genome.jp/kegg/catalog/org_list.html.}

\item{updateCache}{A parameter to enable/disable cache update.}
}
\value{
A named list with three elements: network, names and sizes for CePa.ORA and CePa.GSA methods.
}
\description{
Get KEGG pathway catalogue for CePa.ORA and CePa.GSA methods
}
\examples{
\donttest{
cepaNetwork <- getCePaPathwayCatalogue("hsa")
}
}
