% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-lips1.R
\docType{data}
\name{lips1}
\alias{lips1}
\title{Lips data}
\format{
A data frame with 56 observations on the following 41 variables:
\describe{
\item{area}{Region ID.}
\item{cons}{Constant (=1).}
\item{obs}{Observed cases of lip cancer.}
\item{exp}{Expected count.}
\item{perc_aff}{Percentage of the region who work in agriculture, fishing and
forestry.}
\item{offs}{Log of the expected count.}
\item{pcons}{Constant (=1).}
\item{denom}{Constant (=1).}
\item{neigh1}{First neighbours.}
\item{neigh2}{Second neighbours.}
\item{neigh3}{Third neighbours.}
\item{neigh4}{Fourth neighbours.}
\item{neigh5}{Fifth neighbours.}
\item{neigh6}{Sixth neighbours.}
\item{neigh7}{Seventh neighbours.}
\item{neigh8}{Eighth neighbours.}
\item{neigh9}{Ninth neighbours.}
\item{neigh10}{Tenth neightbours.}
\item{neigh11}{Eleventh neightbours.}
\item{weight1}{First neighbours' weights.}
\item{weight2}{Second neighbours' weights.}
\item{weight3}{Third neighbours' weights.}
\item{weight4}{Fourth neighbours' weights.}
\item{weight5}{Fifth neighbours' weights.}
\item{weight6}{Sixth neighbours' weights.}
\item{weight7}{Seventh neighbours' weights.}
\item{weight8}{Eighth neighbours' weights.}
\item{weight9}{Ninth neighbours' weights.}
\item{weight10}{Tenth neightbours' weights.}
\item{weight11}{Eleventh neightbours' weights.}
\item{wcar1}{First neighbours' CAR weights.}
\item{wcar2}{Second neighbours' CAR weights.}
\item{wcar3}{Third neighbours' CAR weights.}
\item{wcar4}{Fourth neighbours' CAR weights.}
\item{wcar5}{Fifth neighbours' CAR weights.}
\item{wcar6}{Sixth neighbours' CAR weights.}
\item{wcar7}{Seventh neighbours' CAR weights.}
\item{wcar8}{Eighth neighbours' CAR weights.}
\item{wcar9}{Ninth neighbours' CAR weights.}
\item{wcar10}{Tenth neightbours' CAR weights.}
\item{wcar11}{Eleventh neightbours' CAR weights.}
}
}
\source{
Browne, W. J. (2012) \emph{MCMC Estimation in MLwiN Version 2.26.}
University of Bristol: Centre for Multilevel Modelling.

Clayton, D., Kaldor, J. (1987) Empirical Bayes estimates of age-standardized
relative risks for use in disease mapping. \emph{Biometrics} 43: 671-681.

Rasbash, J., Charlton, C., Browne, W.J., Healy, M. and Cameron, B. (2009)
\emph{MLwiN Version 2.1.} Centre for Multilevel Modelling, University of
Bristol.
}
\usage{
lips1
}
\description{
Observed counts of male lip cancer for the 56 regions of Scotland over the
period 1975-1980.
}
\details{
The \code{lips1} dataset is one of the sample datasets provided with the
multilevel-modelling software package MLwiN (Rasbash et al., 2009), and was
analysed in Clayton & Kaldor (1987); see also Browne (2012) for more
details.
}
\examples{

\dontrun{

data(lips1, package = "R2MLwiN")

(mymodel <- runMLwiN(log(obs) ~ 1 + perc_aff + offset(offs) + (0 | neigh1) + (1 | area),
 D = "Poisson", estoptions = list(EstM = 1), data = lips1))

}

}
\keyword{datasets}
