#' Example dataset 1 - The OSLO term infant gut microbiota dataset.
#'
#' A count table used as an example for MicrobTiSDA functions.
#'
#' @format A data frame with 476921 rows (OTUs) and 77 columns (samples).
#' @examples
#' data("OSLO.infant.data")
#' head("OSLO.infant.data")
"OSLO.infant.data"


#' Example dataset 1 - sample metadata.
#'
#' Metadata corresponding to the samples in counts of the OSLO Term infant gut microbiota dataset.
#'
#' @format A data frame with 77 rows (samples) and 4 columns (variables).
#' @examples
#' data("OSLO.infant.meta")
#' head("OSLO.infant.meta")
"OSLO.infant.meta"


#' Example dataset 1 - taxonomic information.
#'
#' Taxonomic classification for the OTUs in the OSLO Term infant gut microbiota dataset.
#'
#' @format A data frame with 476921 rows (OTUs) and 8 columns (taxonomy levels).
#' @examples
#' data("OSLO.infant.taxa")
#' head("OSLO.infant.taxa")
"OSLO.infant.taxa"



#' Example dataset 2 - The in vitro aquatic microbiota dataset.
#'
#' A count table used as an example for MicrobTiSDA functions.
#'
#' @format A data frame with 28 rows (ASVs) and 880 columns (samples).
#' @examples
#' data("fujita.data")
#' head("fujita.data")
"fujita.data"


#' Example dataset 2 - sample metadata.
#'
#' Metadata corresponding to the samples in counts of the in vitro aquatic microbiota dataset.
#'
#' @format A data frame with 880 rows (samples) and 8 columns (variables).
#' @examples
#' data("fujita.meta")
#' head("fujita.meta")
"fujita.meta"


#' Example dataset 2 - taxonomic information.
#'
#' Taxonomic classification for the ASVs in the in vitro aquatic microbiota dataset.
#'
#' @format A data frame with 565 rows (ASVs) and 9 columns (taxonomy levels).
#' @examples
#' data("fujita.taxa")
#' head("fujita.taxa")
"fujita.taxa"



#' Example dataset 3 - The preterm infant gut microbiota dataset.
#'
#' A count table used as an example for MicrobTiSDA functions.
#'
#' @format A data frame with 202 rows (ASVs) and 51 columns (samples).
#' @examples
#' data("preterm.data")
#' head("preterm.data")
"preterm.data"


#' Example dataset 3 - sample metadata.
#'
#' Metadata corresponding to the samples in counts of the in vitro aquatic microbiota dataset.
#'
#' @format A data frame with 51 rows (samples) and 36 columns (variables).
#' @examples
#' data("preterm.meta")
#' head("preterm.meta")
"preterm.meta"


#' Example dataset 3 - taxonomic information.
#'
#' Taxonomic classification for the ASVs in the in vitro aquatic microbiota dataset.
#'
#' @format A data frame with 923 rows (ASVs) and 7 columns (taxonomy levels).
#' @examples
#' data("preterm.taxa")
#' head("preterm.taxa")
"preterm.taxa"
