% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pinball_scores.R
\name{get_pinball_scores}
\alias{get_pinball_scores}
\title{Calculate Pinball Scores for IBLM and Additional Models}
\usage{
get_pinball_scores(
  data,
  iblm_model,
  trim = NA_real_,
  additional_models = list()
)
}
\arguments{
\item{data}{Data frame.
If you have used `split_into_train_validate_test()` this will be the "test" portion of your data.}

\item{iblm_model}{Fitted IBLM model object of class "iblm"}

\item{trim}{Numeric trimming parameter for IBLM predictions. Default is `NA_real_`.}

\item{additional_models}{(Named) list of fitted models for comparison. These models MUST be fitted on the same data as `iblm_model` for sensible results.
If unnamed, models are labeled by their class.}
}
\value{
Data frame with 3 columns:
\itemize{
  \item "model" - will be homog, glm, iblm and any other models specified in `additional_models`
  \item "`family`_deviance" - the value from the loss function based on the family of the glm function
  \item "pinball_score" - The more positive the score, the better the model than a basic homog model (i.e. all predictions are mean value). A negative score indicates worse than homog model.
}
}
\description{
Computes Poisson deviance and pinball scores for an IBLM model alongside
homogeneous, GLM, and optional additional models.
}
\details{
Pinball scores are calculated relative to a homogeneous model (i.e. a simple mean prediction of training data).
Higher scores indicate better predictive performance.
}
\examples{
df_list <- freMTPLmini |> split_into_train_validate_test(seed = 9000)

iblm_model <- train_iblm_xgb(
  df_list,
  response_var = "ClaimRate",
  family = "poisson"
)

get_pinball_scores(data = df_list$test, iblm_model = iblm_model)

}
