% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitive.R
\name{detect_sensitive_columns}
\alias{detect_sensitive_columns}
\title{Detect sensitive columns by name}
\usage{
detect_sensitive_columns(x_names, extra_patterns = NULL, override_regex = NULL)
}
\arguments{
\item{x_names}{Character vector of column names to check.}

\item{extra_patterns}{Character vector of additional regexes to OR in.
Examples: c("MRN", "NHS", "Aadhaar", "passport")}

\item{override_regex}{Optional single regex string that fully replaces the
defaults (case-insensitive). When supplied, \code{extra_patterns} is ignored.}
}
\value{
Character vector of names from \code{x_names} that matched.
}
\description{
Uses a broad, configurable regex library to match likely PII columns.
You can extend it with \code{extra_patterns} (they get ORed in) or replace
everything with a single \code{override_regex}.
}
\examples{
detect_sensitive_columns(c("id","email","home_phone","zip","notes"))
detect_sensitive_columns(names(mtcars), extra_patterns = c("^vin$", "passport"))
}
