% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.gmjmcmc_parallel}
\alias{predict.gmjmcmc_parallel}
\title{Predict Using a GMJMCMC Result Object from a Parallel Run}
\usage{
\method{predict}{gmjmcmc_parallel}(
  object,
  x,
  link = function(x) x,
  quantiles = c(0.025, 0.5, 0.975),
  x_train = NULL,
  ...
)
}
\arguments{
\item{object}{The model to use.}

\item{x}{The new data to use for the prediction, a matrix where each row is an observation.}

\item{link}{The link function to use}

\item{quantiles}{The quantiles to calculate credible intervals for the posterior modes (in model space).}

\item{x_train}{Training design matrix to be provided when imputations are to be made from them}

\item{...}{Additional arguments to pass to merge_results.}
}
\value{
A list containing aggregated predictions and per model predictions.
\item{aggr}{Aggregated predictions with mean and quantiles.}
\item{preds}{A list of lists containing individual predictions per model per population in object.}
}
\description{
Predict Using a GMJMCMC Result Object from a Parallel Run
}
\examples{
result <- gmjmcmc.parallel(
 runs = 1,
 cores = 1,
 x = matrix(rnorm(600), 100),
 y = matrix(rnorm(100), 100),
 P = 2,
 transforms = c("p0", "exp_dbl")
)
preds <- predict(result, matrix(rnorm(600), 100))

}
