% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window.R
\name{window}
\alias{window}
\alias{window_by_rhythm}
\title{Window signal data based on different methods}
\usage{
window(object, window_method = c("rhythm"), ...)

window_by_rhythm(
  object,
  rhythm_type = "sinus",
  onset_criteria,
  offset_criteria,
  reference_criteria = NULL,
  adjust_sample_indices = TRUE,
  ...
)
}
\arguments{
\item{object}{Object of the \code{egm} class, which includes header, signal
information, and annotation information.}

\item{window_method}{A \code{character} string specifying the windowing method.
Options include:
\itemize{
\item \strong{rhythm} - Windows based on rhythm patterns (requires rhythm_type and criteria)
}}

\item{...}{Additional arguments passed to specific windowing methods.}

\item{rhythm_type}{A \code{character} string specifying the rhythm type (e.g.,
"sinus"). Currently supported: "sinus" (requires reference check).}

\item{onset_criteria}{A named list of criteria to identify onset points.
Names should match column names in the annotation table.}

\item{offset_criteria}{A named list of criteria to identify offset points.
Names should match column names in the annotation table.}

\item{reference_criteria}{A named list of criteria to identify reference
points that must exist between onset and offset. Set to NULL to skip
reference validation.}

\item{adjust_sample_indices}{Logical, whether to adjust annotation sample
indices in the returned windows to be relative to the window start. Default
is TRUE.}
}
\value{
A list of \code{egm} objects, each representing a window of the original
signal.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Creates windows of signal data using various methods, such as rhythm patterns,
time intervals, or reference points. Each window is returned as an individual
\code{egm} object for further analysis.
}
\details{
This function provides a modular approach to windowing electrophysiological
signals. The method parameter determines the windowing strategy, with each
method requiring its own set of additional parameters.
}
