% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/any_polyphyly.R
\name{any_polyphyly}
\alias{any_polyphyly}
\title{Checks whether there are any species in the phylogeny that have multiple
tips (i.e. multiple subspecies per species) and whether any of those tips are
paraphyletic (i.e. are their subspecies more distantly related to each other
than to other subspecies or species).}
\usage{
any_polyphyly(phylod)
}
\arguments{
\item{phylod}{A \code{phylo4d} object from the package \code{phylobase} containing
phylogenetic and endemicity data for each species.}
}
\value{
Boolean
}
\description{
Checks whether there are any species in the phylogeny that have multiple
tips (i.e. multiple subspecies per species) and whether any of those tips are
paraphyletic (i.e. are their subspecies more distantly related to each other
than to other subspecies or species).
}
\examples{
phylod <- create_test_phylod(test_scenario = 1)
any_polyphyly(phylod)
}
