% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{cost_clusters_from_dissim_medoids}
\alias{cost_clusters_from_dissim_medoids}
\title{Compute the cost and clusters based on an input dissimilarity matrix and medoids}
\usage{
cost_clusters_from_dissim_medoids(data, medoids)
}
\arguments{
\item{data}{a dissimilarity matrix, where the main diagonal equals 0.0 and the number of rows equals the number of columns}

\item{medoids}{a vector of output medoids of the 'Cluster_Medoids', 'Clara_Medoids' or any other 'partition around medoids' function}
}
\value{
a list object that includes the cost and the clusters
}
\description{
Compute the cost and clusters based on an input dissimilarity matrix and medoids
}
\examples{

data(dietary_survey_IBS)
dat = dietary_survey_IBS[, -ncol(dietary_survey_IBS)]
dat = center_scale(dat)

cm = Cluster_Medoids(dat, clusters = 3, distance_metric = 'euclidean', swap_phase = TRUE)
res = cost_clusters_from_dissim_medoids(data = cm$dissimilarity_matrix, medoids = cm$medoid_indices)

# cm$best_dissimilarity == res$cost
# table(cm$clusters, res$clusters)
}
\author{
Lampros Mouselimis
}
