% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_brazil_cep.R
\name{get_brazil_cep}
\alias{get_brazil_cep}
\title{Get Address Information by Brazilian CEP (Postal Code)}
\usage{
get_brazil_cep(cep)
}
\arguments{
\item{cep}{A valid Brazilian postal code (CEP) with 8 digits (e.g., "89010025").}
}
\value{
A data frame (tibble) with the following columns:
\itemize{
  \item \code{cep}: The CEP (postal code).
  \item \code{state}: State abbreviation (e.g., SP, RJ).
  \item \code{city}: City or municipality.
  \item \code{neighborhood}: Neighborhood.
  \item \code{street}: Street name.
  \item \code{service}: Name of the API service used.
}
}
\description{
This function retrieves detailed address information for a given Brazilian
postal code (CEP) using the BrasilAPI endpoint.
}
\details{
Example URL format: \url{https://brasilapi.com.br/api/cep/v1/89010025}

Replace \code{89010025} with any valid Brazilian postal code (CEP).


The function sends a GET request to the BrasilAPI CEP endpoint. If the request
is successful and the response contains the expected fields, it returns a
structured tibble. Otherwise, a message is displayed and \code{NULL} is returned.
}
\note{
Requires an internet connection. Make sure the CEP is correctly formatted (only digits, 8 characters).
}
\examples{
\dontrun{
# Look up information for a specific CEP
get_brazil_cep("89010025")
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
